import asyncio
import websockets
import ssl

async def test_ws():
    uri = "ws://raito-pts.com:8080/ws"  # مسار أساسي فقط  # تأكد من صحة المسار
    ssl_context = ssl.create_default_context()  # الحصول على SSL Context بشكل آمن
    ssl_context.check_hostname = False  # تعطيل التحقق من اسم المضيف (للبيئة التجريبية)
    ssl_context.verify_mode = ssl.CERT_NONE  # تعطيل التحقق من الشهادات (للبيئة التجريبية)

    for attempt in range(3):  # المحاولة 3 مرات في حال الفشل
        try:
            print(f"🔄 محاولة الاتصال {attempt + 1}...")
            async with websockets.connect(uri, ssl=ssl_context) as websocket:
                print("✅ تم الاتصال بنجاح!")
                await websocket.send("اختبار الاتصال")
                response = await websocket.recv()
                print(f"📩 استجابة السيرفر: {response}")
                return  # خروج من الدالة عند نجاح الاتصال
        except websockets.exceptions.InvalidURI:
            print("❌ خطأ: عنوان WebSocket غير صحيح.")
            break
        except websockets.exceptions.WebSocketException as e:
            print(f"❌ فشل الاتصال: {e}")
        except ssl.SSLError as e:
            print(f"❌ خطأ في SSL: {e}")
        except Exception as e:
            print(f"❌ خطأ غير متوقع: {e}")
        
        print(f"🔄 إعادة المحاولة ({attempt + 1}/3)...")
        await asyncio.sleep(1)  # انتظار قبل إعادة المحاولة

    print("🚫 لم يتمكن من الاتصال بعد 3 محاولات.")

asyncio.run(test_ws())
