# Enhanced Fuel Prices Dashboard

This is an improved real-time dashboard for displaying and managing fuel prices that updates via WebSocket connection.

## Features

- **Modern UI Design**: Clean, responsive interface that works on all devices
- **Real-time Updates**: Shows fuel prices with visual feedback when changes occur
- **Price Management**: Allows manual price updates for each fuel type
- **System Log**: Tracks all events and price changes with timestamps
- **Robust Connection Handling**: Auto-reconnect with exponential backoff
- **Visual Status Indicators**: Connection status with colored badges

## Files

- `fuel-prices-enhanced.html` - The enhanced dashboard for displaying and managing fuel prices
- `test-websocket.php` - A test WebSocket server for simulating price updates (optional)

## How to Use

### Viewing Prices

1. Access the dashboard at: http://localhost/PTS/laravel-pts/public/fuel-prices-enhanced.html
2. The dashboard will automatically connect to the WebSocket server
3. Current prices will be displayed in real-time with visual highlighting on changes

### Updating Prices

1. Enter a new price in the input field below any fuel type
2. Click the "Update Price" button
3. The price will be updated on the server and synchronized to all connected clients
4. The system log will show the price change event

## WebSocket Integration

The dashboard communicates with the WebSocket server using the following JSON format:

```json
{
  "Protocol": "jsonPTS",
  "Packets": [
    {
      "Id": 1,
      "Type": "SetFuelGradesConfiguration",
      "Data": {
        "FuelGrades": [
          {
            "Id": 1,
            "Name": "P91",
            "Price": 27.50
          },
          {
            "Id": 2,
            "Name": "P95",
            "Price": 23.99
          },
          {
            "Id": 3,
            "Name": "Diesel",
            "Price": 23.99
          }
        ]
      }
    }
  ]
}
```

## Running the WebSocket Server

### Option 1: Using the Main WebSocket Server

1. Start the Laravel application
2. In a separate terminal, start the WebSocket server:
   ```
   php websocket_server.php
   ```

### Option 2: Using the Test Server (for development)

1. Open a terminal in the Laravel project directory
2. Run the test WebSocket server:
   ```
   php public/test-websocket.php
   ```

## Troubleshooting

- If the connection status shows "Disconnected" or "Connection Error", ensure the WebSocket server is running
- Check browser console (F12) for detailed error messages
- The system log at the bottom of the page shows connection events and errors
- If maximum reconnection attempts are reached, refresh the page to try again

## Browser Compatibility

This dashboard works in all modern browsers with WebSocket support:

- Chrome 16+
- Firefox 11+
- Safari 7+
- Edge 12+
- Opera 12.1+

## Customization

The dashboard can be customized by modifying the CSS variables at the top of the style section:

```css
:root {
    --primary-color: #3498db;
    --secondary-color: #2ecc71;
    --danger-color: #e74c3c;
    --warning-color: #f39c12;
    --dark-color: #2c3e50;
    --light-color: #ecf0f1;
    --gray-color: #95a5a6;
    --white-color: #ffffff;
    --shadow: 0 4px 6px rgba(0, 0, 0, 0.1), 0 1px 3px rgba(0, 0, 0, 0.08);
    --transition: all 0.3s ease;
}
``` 