<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);

require __DIR__ . '/vendor/autoload.php';

// Bootstrap Laravel properly
$app = require __DIR__ . '/bootstrap/app.php';
$kernel = $app->make(Illuminate\Contracts\Console\Kernel::class);
$kernel->bootstrap();

use Ratchet\Http\HttpServer;
use Ratchet\Server\IoServer;
use Ratchet\WebSocket\WsServer;
use App\Http\Controllers\WebSocketController;
use React\EventLoop\Loop;
use React\Socket\SocketServer;

echo "Starting WebSocket server on port 8080...\n";

try {
    $loop = Loop::get();
    $controller = new WebSocketController();
    $ws = new WsServer($controller);
    $ws->enableKeepAlive($loop);
    
    $socket = new SocketServer('69.167.168.152:8080', [], $loop);
    
    $server = new IoServer(
        new HttpServer($ws),
        $socket,
        $loop
    );

    echo "WebSocket server started successfully!\n";
    echo "Listening on port 8080...\n";
    
    $server->run();
} catch (\Exception $e) {
    echo "Error: " . $e->getMessage() . "\n";
    echo "Stack trace: \n" . $e->getTraceAsString() . "\n";
}

