<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <title>نظام إدارة أسعار الوقود</title>
    <link href="https://fonts.googleapis.com/css2?family=Cairo:wght@400;600;700&display=swap" rel="stylesheet">
    <!-- Your existing style content -->
</head>
<body>
    <div class="container">
        <h1>نظام إدارة أسعار الوقود</h1>
        
        <div class="status-bar">
            <div class="connection-status">
                <span>حالة الاتصال:</span>
                <div class="status-dot" id="statusDot"></div>
                <span id="statusText">جارِ الاتصال...</span>
            </div>
        </div>

        <div class="fuel-card">
            <div>
                <h3>بنزين 91</h3>
                <div class="price-section">
                    <span class="current-price">السعر الحالي: <span id="currentP91">{{ $currentP91 }}</span> ر.س</span>
                    <input type="number" step="0.01" class="price-input" id="p91" placeholder="أدخل السعر الجديد">
                </div>
            </div>
        </div>

        <div class="fuel-card">
            <div>
                <h3>بنزين 95</h3>
                <div class="price-section">
                    <span class="current-price">السعر الحالي: <span id="currentP95">{{ $currentP95 }}</span> ر.س</span>
                    <input type="number" step="0.01" class="price-input" id="p95" placeholder="أدخل السعر الجديد">
                </div>
            </div>
        </div>

        <div class="fuel-card">
            <div>
                <h3>ديزل</h3>
                <div class="price-section">
                    <span class="current-price">السعر الحالي: <span id="currentDiesel">{{ $currentDiesel }}</span> ر.س</span>
                    <input type="number" step="0.01" class="price-input" id="diesel" placeholder="أدخل السعر الجديد">
                </div>
            </div>
        </div>

        <button class="update-btn" onclick="sendUpdate()">تحديث الأسعار</button>
        <div id="message" class="message"></div>
    </div>

    <script>
        const wsEndpoint = 'ws://69.167.168.152:8080';
        let socket;

        // Your existing JavaScript content
    </script>
</body>
</html>