<!DOCTYPE html>
<html dir="rtl" lang="ar">
<head>
    <meta charset="UTF-8">
    <title>إدارة أسعار الوقود</title>
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <style>
        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            padding: 20px;
        }
        .price-card {
            background-color: #f8f9fa;
            padding: 20px;
            border-radius: 8px;
            margin-bottom: 20px;
            box-shadow: 0 2px 4px rgba(0,0,0,0.1);
        }
        .price-value {
            font-size: 24px;
            font-weight: bold;
            color: #198754;
        }
        .status-badge {
            position: fixed;
            top: 20px;
            left: 20px;
            z-index: 1000;
        }
    </style>
</head>
<body>
    <div class="container">
        <h1 class="text-center mb-4">إدارة أسعار الوقود</h1>
        
        <span id="wsStatus" class="badge bg-secondary status-badge">جاري الاتصال...</span>

        <div class="row">
            <div class="col-md-4">
                <div class="price-card">
                    <h3>بنزين 91</h3>
                    <div class="price-value" id="p91-price">--</div>
                    <div class="mt-3">
                        <input type="number" class="form-control" id="p91-input" step="0.01" placeholder="السعر الجديد">
                    </div>
                </div>
            </div>
            
            <div class="col-md-4">
                <div class="price-card">
                    <h3>بنزين 95</h3>
                    <div class="price-value" id="p95-price">--</div>
                    <div class="mt-3">
                        <input type="number" class="form-control" id="p95-input" step="0.01" placeholder="السعر الجديد">
                    </div>
                </div>
            </div>
            
            <div class="col-md-4">
                <div class="price-card">
                    <h3>ديزل</h3>
                    <div class="price-value" id="diesel-price">--</div>
                    <div class="mt-3">
                        <input type="number" class="form-control" id="diesel-input" step="0.01" placeholder="السعر الجديد">
                    </div>
                </div>
            </div>
        </div>

        <div class="row mt-4">
            <div class="col-12 text-center">
                <button class="btn btn-primary btn-lg" onclick="updatePrices()">تحديث الأسعار</button>
            </div>
        </div>

        <div id="statusMessage" class="alert mt-3" style="display: none;"></div>
    </div>

    <script>
        const ws = new WebSocket('ws://localhost:8080');
        let lastPrices = {
            p91: 0,
            p95: 0,
            diesel: 0
        };

        ws.onopen = function() {
            updateStatus('متصل', 'success');
        };

        ws.onclose = function() {
            updateStatus('غير متصل', 'danger');
            setTimeout(() => location.reload(), 5000);
        };

        ws.onmessage = function(event) {
            try {
                const data = JSON.parse(event.data);
                if (data.Protocol === 'jsonPTS') {
                    const packet = data.Packets[0];
                    if (packet.Data.FuelGrades) {
                        updatePriceDisplay(packet.Data.FuelGrades);
                    }
                }
            } catch (e) {
                console.error('Error processing message:', e);
            }
        };

        function updatePriceDisplay(fuelGrades) {
            fuelGrades.forEach(grade => {
                switch(grade.Name.toLowerCase()) {
                    case 'p91':
                        document.getElementById('p91-price').textContent = grade.Price + ' ريال';
                        lastPrices.p91 = grade.Price;
                        break;
                    case 'p95':
                        document.getElementById('p95-price').textContent = grade.Price + ' ريال';
                        lastPrices.p95 = grade.Price;
                        break;
                    case 'diezel':
                    case 'diesel':
                        document.getElementById('diesel-price').textContent = grade.Price + ' ريال';
                        lastPrices.diesel = grade.Price;
                        break;
                }
            });
        }

        function updatePrices() {
            const prices = {
                p91: document.getElementById('p91-input').value || lastPrices.p91,
                p95: document.getElementById('p95-input').value || lastPrices.p95,
                diesel: document.getElementById('diesel-input').value || lastPrices.diesel
            };

            const data = {
                "Protocol": "jsonPTS",
                "Packets": [{
                    "Id": 1,
                    "Type": "SetFuelGradesConfiguration",
                    "Data": {
                        "FuelGrades": [
                            {
                                "Id": 1,
                                "Name": "P91",
                                "Price": parseFloat(prices.p91)
                            },
                            {
                                "Id": 2,
                                "Name": "P95",
                                "Price": parseFloat(prices.p95)
                            },
                            {
                                "Id": 3,
                                "Name": "Diesel",
                                "Price": parseFloat(prices.diesel)
                            }
                        ]
                    }
                }]
            };

            ws.send(JSON.stringify(data));
            showMessage('تم إرسال تحديث الأسعار', 'info');
        }

        function updateStatus(message, type) {
            const status = document.getElementById('wsStatus');
            status.className = `badge bg-${type} status-badge`;
            status.textContent = message;
        }

        function showMessage(message, type) {
            const alert = document.getElementById('statusMessage');
            alert.className = `alert alert-${type} mt-3`;
            alert.textContent = message;
            alert.style.display = 'block';
            setTimeout(() => alert.style.display = 'none', 3000);
        }
    </script>
</body>
</html>