# Fuel Prices Dashboard

This is a real-time dashboard for displaying fuel prices that updates via WebSocket connection.

## Files

- `fuel-prices.html` - The main dashboard that displays fuel prices
- `test-websocket.php` - A test WebSocket server for simulating price updates

## Features

- Displays current prices for P91, P95, and Diesel fuel
- Real-time updates via WebSocket connection
- Visual highlighting when prices change
- Connection status indicator
- Last update timestamp

## How to Use

### Option 1: Using with Laravel WebSocket Server

1. Start the Laravel application
2. In a separate terminal, start the WebSocket server:
   ```
   php websocket_server.php
   ```
3. Access the dashboard at: http://localhost/PTS/laravel-pts/public/fuel-prices.html

### Option 2: Using the Test Server (for development)

1. Open a terminal in the Laravel project directory
2. Run the test WebSocket server:
   ```
   php public/test-websocket.php
   ```
3. Access the dashboard at: http://localhost/PTS/laravel-pts/public/fuel-prices.html

## WebSocket Message Format

The dashboard expects WebSocket messages in the following format:

```json
{
  "Protocol": "jsonPTS",
  "Packets": [
    {
      "Id": 1,
      "Type": "SetFuelGradesConfiguration",
      "Data": {
        "FuelGrades": [
          {
            "Id": 1,
            "Name": "P91",
            "Price": 27.50
          },
          {
            "Id": 2,
            "Name": "P95",
            "Price": 23.99
          },
          {
            "Id": 3,
            "Name": "Diesel",
            "Price": 23.99
          }
        ]
      }
    }
  ]
}
```

## Customization

You can customize the appearance by modifying the CSS in the `fuel-prices.html` file.

## Troubleshooting

- If you're having connection issues, make sure the WebSocket server is running
- Check that the WebSocket URL in the JavaScript code matches your server configuration
- For development, you can use browser developer tools to see WebSocket communication 